<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RoomType extends Model 
{

    protected $table = 'room_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function features()
    {
        return $this->hasMany('App\Models\PropertiesFeature', 'room_type_id');
    }

    public function property_type()
    {
        return $this->belongsTo('App\Models\PropertyType', 'property_type_id');
    }

}